/* Antarmuka dengan OLED Display 128x64 - Basic IoT Kit ESP32
 * Project : Menampilkan Teks dengan Aplikasi IoT KIT
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP32 WiFi dan Firebase ESP32
#include <WiFi.h>
#include <FirebaseESP32.h>

// Library OLED Display
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

// Mengatur OLED Display dengan resolusi 128x64
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET    -1
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// Firebase objek dengan nama fbdo
FirebaseData fbdo;

// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);
  
  // Memulai komunikasi dengan OLED Display
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);
  
  // Membersihkan tampilan display
  display.clearDisplay();
}

void loop() {
  display.setTextSize(1);           // Mengatur ukuran teks = 1
  display.setTextColor(WHITE);      // Mengatur teks warna putih
  display.setCursor(1,1);           // Mengatur kursor (x:1, y:1)
  display.print("Basic IoT Kit");   // Mencetak Teks "Basic IoT Kit"

  // Membaca database pada alamat */user/switch1
  // Jika bernilai true menampilkan Data ON
  // Jika bernilai true menampilkan Data OFF
  if(Firebase.getString(fbdo, "/" + user + "/switch1")) {
    if(fbdo.to<bool>() == true){
      display.setTextSize(2);       // Mengatur ukuran teks = 2
      display.setTextColor(WHITE);  // Mengatur teks warna putih
      display.setCursor(1,25);      // Mengatur kursor (x:1, y:25)
      display.print("Data ON");     // Mencetak Teks "Data ON";
    }else{
      display.setTextSize(2);       // Mengatur ukuran teks = 2
      display.setTextColor(WHITE);  // Mengatur teks warna putih
      display.setCursor(1,25);      // Mengatur kursor (x:1, y:25)
      display.print("Data OFF");    // Mencetak Teks "Data OFF";
    }
  }
  display.display();      // Menampilkan data
  display.clearDisplay(); // Membersihkan tampilan display
}
